class Ex5_5
parameter Real p(unit="lb/ft^2")=2102;/*pressure at a point on the airfoil*/

parameter Real p_infinite(unit="lb/ft^2")=2116;/*atmospheric pressure at sea level*/
parameter Real rho_infinite(unit="slug/ft^3")=0.002377;/*atmospheric density at sea level*/

parameter Real V_infinite(unit="ft/s")=100;/*velocity at test section*/
parameter Real M_infinite=0.6;/*free stream Mach number*/

Real q_infinite(unit="lb/ft^2");/*dynamics pressure*/
Real C_p0;/*pressure coefficient for icompressible flow in secified point of the airfoil*/
Real C_p;/*pressure coefficient for compressible flow in secified point of the airfoil*/
equation
q_infinite=(1/2)*rho_infinite*V_infinite^2;
C_p0=(p-p_infinite)/q_infinite;
C_p=C_p0/sqrt(1-M_infinite^2);
end Ex5_5;
