class Ex5_6
Real p(unit="N/m^2");/*pressure at a point on the fuselage of the airplane*/

parameter Real p_infinite(unit="N/m^2")=7.0121*10^4;/*atmospheric pressure at 3 km*/
parameter Real rho_infinite(unit="kg/m^3")=0.90926;/*atmospheric density at 3 km*/
parameter Real V_infinite(unit="m/s")=100;/*velocity of the airplane*/

Real q_infinite(unit="N/m^2");/*dynamics pressure*/
parameter Real C_p=-2.2;/*pressure coefficient in secified point of the fuselage*/
equation
q_infinite=(1/2)*rho_infinite*V_infinite^2;
C_p=(p-p_infinite)/q_infinite;
end Ex5_6;
