class Ex6_12
/*Weight conversion 1 gal=5.64 lb */
/*specific fuel conversion 1 lb/hp.h= 1/(550*3600) ft^(-1)*/

parameter Real eta=0.8;/*efficiency of the CP-1*/
parameter Real rho_infinite(unit="slug/ft^3")=0.002377;/*atmospheric density at sea level*/

parameter Real c_1(unit="lb/hp.h")=0.45;/*specific fuel consumption in lb/hp.h*/
Real c(unit="ft^(-1)");/*specific fuel consumption in per ft*/

parameter Real C_L_b_C_D_max=13.62;/*maximum C_L by C_D ratio*/
parameter Real C_L_b_C_D_max1=12.81;/*maximum C_L^(3/2) by C_D ratio*/

parameter Real S(unit="ft^2")=174;/*wing area*/

parameter Real W_0(unit="lb")=2950;/*gross weight of the CP-1*/
parameter Real W_g(unit="gal")=65;/*weight of aviation gasoline in galon*/
Real W_p(unit="lb");/*weight of aviation gasoline in lb*/
Real W_1(unit="lb");/*empty weight of CP-1*/

Real R(unit="ft");/*maximum range*/
Real E(unit="s");/*maximum endurance*/

equation
c=c_1/(550*3600);

W_p=W_g*5.64;
W_1=W_0-W_p;

R=(eta/c)*C_L_b_C_D_max*log(W_0/W_1);

E=(eta/c)*C_L_b_C_D_max1*(sqrt(2*rho_infinite*S))*((1/sqrt(W_1))-(1/sqrt(W_0)));

/*The  answer may slightly vary due to  rounding off values*/
end Ex6_12;
