class Ex6_2
parameter Real pi = Modelica.Constants.pi;

parameter Integer n=100;

parameter Real W_j(unit="lb")=19815;/*normal gross weight*/
parameter Real b_j(unit="ft")=53.3;/*wingspan of the aircraft*/
parameter Real S_j(unit="ft^2")=318;/*wing area of the aircraft*/
parameter Real e_j =0.81;/*span efficiency factor*/


parameter Real rho_infinite_j(unit="slug/ft^3")=0.002377;/* atmospheric density*/

Real V_j[n](each unit="ft/s");/*={300,600,700,850,1000};/*flight velocity of aircraft*/

Real C_L_j[n];/*lift coefficient*/
Real AR_j;/*aspect ratio of the aircraft*/

parameter Real C_D0_j=0.02;/*parasite drag coefficient*/
Real C_D_j[n];/*total drag coefficient**/
Real L_by_D_j[n];/*ratio between thrust and drag*/

Real T_R_j[n](each unit="lb");/*thrust required for the aircraft*/

parameter Real T_A(unit="lb")=2*3650;/*total thrust*/

Real V_max_array[n](each unit="ft/s");/*array for maximum velocity*/
Real V_max(unit="ft/s");/*maximum velocity*/

parameter Real a(unit="ft/s")=1117;/*sea level speed of sound*/
Real M_max;/*the maximum sea level Mach number*/ 

algorithm

V_j[1]:=970;

for i in 2:n loop
V_j[i]:=V_j[i-1]+0.10;
end for;

for i in 1:n loop
C_L_j[i]:=W_j/((1/2)*rho_infinite_j*V_j[i]^2*S_j);

AR_j:=b_j^2/S_j;

C_D_j[i]:=C_D0_j+C_L_j[i]^2/(pi*e_j*AR_j);

L_by_D_j[i]:=C_L_j[i]/C_D_j[i];

T_R_j[i]:=W_j/L_by_D_j[i];

if(T_R_j[i]>=(T_A-0.5) and T_R_j[i]<=(T_A +1)) then
V_max_array[i]:=V_j[i];
else
V_max_array[i]:=0;
end if;

V_max:=max(V_max_array);
M_max:=V_max/a;
end for;

/*The  answer may slightly vary due to  rounding off values*/
end Ex6_2;
