class Ex6_5
parameter Integer n=5;

Real V_alt[5](each unit="ft/s")={200,300,500,800,1000};/*given velocity point at 22000 ft*/
Real V_0[5](each unit="ft/s");/*generated velocity point at sea level*/

parameter Real rho_infinite_0(unit="slug/ft^3")=0.002377;/*atmospheric density at sea level*/
parameter Real rho_infinite(unit="slug/ft^3")=0.001184;/* atmospheric density at 22000 ft*/

Real hp_R_alt[5](each unit="hp")={889,741,1190,3713,7012};/*given power required point at 22000 ft*/
Real hp_R_0[5](each unit="hp");/*generated power required point at sea level*/

algorithm

for i in 1:n loop
V_0[i]:=V_alt[i]*(rho_infinite/rho_infinite_0)^(1/2);
hp_R_0[i]:=hp_R_alt[i]*(rho_infinite/rho_infinite_0)^(1/2);
end for;
end Ex6_5;                          
