class Ex7_4
parameter Real alpha_0(unit="deg")=-1.5;/*zero lift angle of attack(geometric angle)*/

parameter Real C_M_acwb=-0.032;/*moment coefficient about aerodynamic center*/
parameter Real a(unit="per deg")=0.08;/*lift curve slope of wing*/

parameter Real alpha(unit="deg")=7.88;/*geometric angle angle of attack*/
Real alpha_a(unit="deg");/*absolute angle angle of attack*/

parameter Real h_h_acwb=0.11;/*horizontal distance between center of gravity and aerodynamic center in fraction of chord length*/

parameter Real l_t(unit="m")=0.17;/*distance from the airplane's center of gravity to the tail's aerodynamics center*/
parameter Real S_t(unit="m^2")=0.02;/*tail area*/
parameter Real c(unit="m")=0.1;/*chord length*/
parameter Real S(unit="m^2")=0.1;/*wing area*/

Real V_H;/*tail volume ratio*/
parameter Real a_t(unit="per deg")=0.1;/*tail lift slope*/
parameter Real d_eta_d_alpha=0.35;/*rate of change of downwash angle eta w.e.t.alpha*/
parameter Real i_t(unit="deg")=2.7;/*tail setting angle*/
parameter Real eta_0=0;/*zero lift downwash angle*/

Real C_M_cg;/*moment coefficient about center of gravity*/
equation
alpha_a=alpha+abs(alpha_0); 
V_H=(l_t*S_t)/(c*S);
C_M_cg=C_M_acwb+a*alpha_a*(h_h_acwb-V_H*(a_t/a)*(1-d_eta_d_alpha))+V_H*a_t*(i_t+eta_0);
end Ex7_4;
