class Ex7_8
parameter Real W(unit="N")=2.27*10^4;/*weight of airplane*/
parameter Real rho_infinite(unit="kg/m^3")=1.225;/* atmospheric density*/
parameter Real V_infinite(unit="m/s")=61;/*velocity of the airplane*/
parameter Real S(unit="m^2")=19;/*wing area*/

Real C_L;/*lift coefficient*/
parameter Real a(unit="per deg")=0.08;/*lift slope*/
Real alpha_a(unit="deg");/*absolute angle of attack*/

parameter Real C_M0=0.06;/*moment coefficient about center of gravity at zero lift*/
parameter Real d_C_Mcg_d_alpha_a(unit="per deg")=-0.0133;/*slope of the moment coefficient curve*/
parameter Real alpha_n(unit="deg")=6.5;/*zero moment angle of attack*/
parameter Real V_H=0.34;/*tail volume ratio*/
parameter Real d_C_Lt_d_del_e(unit="per deg")=0.04;/*tail lift curve slope*/

Real delta_trim(unit="deg");/*elevator deflection required to trim the plane*/
equation
C_L=(2*W)/(rho_infinite*V_infinite^2*S);
alpha_a=C_L/a;
delta_trim=(C_M0+d_C_Mcg_d_alpha_a*alpha_n)/(V_H*d_C_Lt_d_del_e);

end Ex7_8;
