class Ex8_1
/*mile to meter conversion, 1 mi=1609.34 m */

parameter Real h_G_mi(unit="mi")=500; /*altitude above sea level in mile*/
Real h_G(unit="m"); /*altitude above sea level in meter*/

parameter Real r_e(unit="m")=6.4*10^6;/*earth radius*/
Real r_b(unit="m");/*the distance from the center of the earth to the burnout point*/

parameter Real k_2(unit="m^3/s^2")=3.986*10^14;/*gravitational parameter*/

Real V_theta(unit="m/s");/*the velocity component perpendicular to the radius r*/

parameter Real beta_b(unit="deg")=3;/*flight path angle at burnout point in degree*/
Real beta_b_rad(unit="rad");/*flight path angle at burnout point in radian*/

Real h(unit="m^2/s");/*angular momentum per unit mass*/
Real p(unit="m");

parameter Real V(unit="m/s")=9*10^3;/*bournout velocity*/
Real G_M(unit="m^3/s^2")=3.986*10^14;/*gravitational parameter*/
Real T_m(unit="m^2/s^2");/*kinetic energy per unit mass*/
Real phi_m(unit="m^2/s^2");/*potential energy per unit mass*/

Real H_m(unit="m^2/s^2");
Real e;/*ecentricity*/

Real theta_b(unit="rad")=0;/*true anomaly at burnout pont*/
Real C(unit="rad");/*phase angle*/

parameter Integer n=150;

Real theta_deg[n](each unit="deg");/*true anomaly in deg*/
Real theta[n](each unit="rad");/*true anomaly in radian*/
Real r[n](each unit="m");/*radial coordinate of the rocket from the center of earth*/

equation
h_G=h_G_mi*1609.34;
r_b=r_e+h_G;

beta_b_rad=Modelica.SIunits.Conversions.from_deg(beta_b);
V_theta=V*cos(beta_b_rad);
h=r_b*V_theta;

p=h^2/k_2;
T_m=V^2/2;
phi_m=G_M/r_b;
H_m=T_m-phi_m;
e=sqrt(1+(2*h^2*H_m)/k_2^2);

r_b=p/(1+e*cos(theta_b-C));

algorithm

theta_deg[1]:=0;

for i in 2:n loop
theta_deg[i]:=theta_deg[i-1]+2;
end for;

for i in 1:n loop
theta[i]:=Modelica.SIunits.Conversions.from_deg(theta_deg[i]);
r[i]:=p/(1+e*cos(theta[i]-C));
end for;
/*The  answer may slightly vary due to  rounding off values*/
end Ex8_1;
