class Ex11_1
parameter Real pi = Modelica.Constants.pi;

parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
Real M_infinite=25;/*Mach number*/
parameter Real s_R=0.6;/*ratio of distance along the sphere and the radius of the sphere*/
Real phi(unit="rad");/*angle between stagnation point and point1*/
Real theta(unit="rad");/*angle between line tangent at point1 and free stream direction*/

Real P_02_P_infinite;/* ratio of total pressure at stagnation point and free stream pressure*/
Real C_p_max;/*maximumpressure coefficient*/
Real C_p;/*pressure coefficient at point1*/
equation
phi=s_R;
theta=pi/2-phi;
P_02_P_infinite=(((((gama+1)^2)*M_infinite^2)/(4*gama*M_infinite^2-2*(gama-1)))^(gama/(gama-1)))*((1-gama+2*gama*M_infinite^2)/(gama+1));
C_p_max=(2/(gama*M_infinite^2))*(P_02_P_infinite-1);
C_p=C_p_max*(sin(theta))^2;
end Ex11_1;
