class Ex3_1
parameter Real h_1(unit="m")=0;/*sea level*/
parameter Real h_2(unit="m")=11*10^3;/*altitude at 11 km*/
parameter Real h(unit="m")=14*10^3;/*altitude at 14 km*/

parameter Real p_1(unit="N/m^2")=1.01*10^5;/*pressure at sea level*/
Real p_2(unit="N/m^2");/*pressure at at 11 km*/
Real p(unit="N/m^2");/*pressure at at 14 km*/

parameter Real rho_1(unit="kg/m^3")=1.23;/*pressure at at sea level*/
Real rho_2(unit="kg/m^3");/*density at at 11 km*/
Real rho(unit="kg/m^3");/*density at at 14 km*/

parameter Real T_1(unit="K")=288.16;/*temperature at at sea level*/
Real T_2(unit="K");/*temperature at at 11 km*/
parameter Real T(unit="K")=216.66;/*temperature at at 14km*/

Real a(unit="K/m");/*lapse rate*/
parameter Real g_0(unit="m/s^2")=9.8;/*Gravitational acceleration*/
parameter Real R(unit="J/(kg.K)")=287;/*Specific Gas Constant of Air*/
equation
T_2=T;
a=(T_2-T_1)/(h_2-h_1);
p_2=p_1*(T_2/T_1)^(-g_0/(a*R));
rho_2=rho_1*(T_2/T_1)^(-((g_0/(a*R))+1));
p=p_2*exp(-(g_0/(R*T))*(h-h_2));
rho/rho_2=p/p_2;
end Ex3_1;
