class Ex3_4
parameter Real h_G1_p(unit="m")=5100;/*pressure altitude in position 1*/
parameter Real h_G2_p(unit="m")=5200;/*pressure altitude in position 2*/
Real h_G_p(unit="m");/*pressure altitude*/

parameter Real p_1(unit="N/m^2")=5.331*10^4;/*pressure in position 1*/
parameter Real p_2(unit="N/m^2")=5.2621*10^4;/*pressure in position 2*/
parameter Real p(unit="N/m^2")=5.3*10^4;/*pressure in h_G_p*/

parameter Real h_G1_rho(unit="m")=5000;/*density altitude in position 1*/
parameter Real h_G2_rho(unit="m")=5100;/*density altitude in position 2*/
Real h_G_rho(unit="m");/*density altitude*/

parameter Real rho_1(unit="kg/m^3")=0.73643;/*density in h_G1_rho*/
parameter Real rho_2(unit="kg/m^3")=0.72851;/*density in h_G2_rho*/
Real rho(unit="kg/m^3");/*density in h_G_rho*/

parameter Real T(unit="K")=253;/*Temperature*/
parameter Real R(unit="J/(kg.K)")=287;/*Specific Gas Constant of Air*/
equation
h_G_p=h_G1_p+(h_G2_p-h_G1_p)*((p_1-p)/(p_1-p_2));

rho=(p/(R*T));

h_G_rho=h_G1_rho+(h_G2_rho-h_G1_rho)*((rho_1-rho)/(rho_1-rho_2));

/*The  answer may slightly vary due to  rounding off values*/

end Ex3_4;
