class Ex4_10
/*Vlocity- 60 mi/h=88 ft/s */
parameter Real p_infinite(unit="lb/ft^2")=2116;/*pressure at the far ahead of the airfoil*/
parameter Real p_A(unit="lb/ft^2")=1497;/*pressure at point A of the airfoil*/

parameter Real V_infinite(unit="mi/h")=500;/*velocity at the far ahead of the airfoil*/
Real V_infinite_fps(unit="ft/s");/*velocity in fps unit at the far ahead of the airfoil*/

parameter Real rho_infinite(unit="slug/ft^3")=0.002377;/*density of air at the far ahead of the airfoil*/


parameter Real c_p(unit="ft.lb/(slug.degR)")=6006;/*specific heat at constant pressure*/
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real R(unit="ft.lb/(slug.degR)")=1716;/*Specific Gas Constant of Air*/

Real T_infinite(unit="degR");/*temperature of air at the far ahead of the airfoil*/ 
Real T_A(unit="degR");/*temperature of air at point A of the airfoil*/ 

Real V_A(unit="ft/s",min=0);/*velocity at point A of the airfoil*/

equation
V_infinite_fps=V_infinite*(88/60);

T_infinite=p_infinite/(rho_infinite*R);
p_A/p_infinite=(T_A/T_infinite)^(gama/(gama-1));

c_p*T_infinite+V_infinite_fps^2/2=c_p*T_A+V_A^2/2;


end Ex4_10;
