class Ex4_15
parameter Real p_1(unit="N/m^2")=1.019*10^5;/*pressure at reservior*/
parameter Real p_2(unit="N/m^2")=1.01*10^5;/*pressure at test section*/
Real p1_p2(unit="N/m^2");/*new pressure difference(double of actual pressure difference)*/
parameter Real A_1(unit="m^2")=2;/*cross section area of reservior*/
parameter Real A_2(unit="m^2")=0.5;/*cross section area of test section*/
Real CR_N;/*New contraction ration of the wind tunnel*/ 
parameter Real rho(unit="kg/m^3")=1.23;/*density of air at tunnel*/
Real V_2_p(unit="m/s");/*airflow velocity at the test sectiondue to change in pressure difference*/
Real V_2_CR(unit="m/s");/*airflow velocity at the test sectiondue to change Contraction ratio*/
equation
/*Number-a*/
p1_p2=2*(p_1-p_2);
V_2_p=sqrt((2*p1_p2)/(rho*(1-(A_2/A_1)^2)));

/*Number-b*/
CR_N=2*(A_1/A_2);
V_2_CR=sqrt((2*(p_1-p_2))/(rho*(1-(1/CR_N^2))));

/*The  answer may slightly vary due to  rounding off values*/
end Ex4_15;
