class Ex4_17
parameter Real R(unit="J/kg*K")=287;/*Specific Gas Constant of Air*/
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/

parameter Real p_s(unit="N/m^2")=1.01*10^5;/*standard atmospheric pressure at sea level*/
parameter Real p_1(unit="N/m^2")=2.65*10^4;/*standard atmospheric pressure at 10 km altitude*/
parameter Real p_0(unit="N/m^2")=4.24*10^4;/*total pressure measured by pitot tube*/

parameter Real T_1(unit="K")=230;/*ambient air temperature at 10 km altitude*/

Real M_1(min=0);/*Mach number at 10 km altitude*/

parameter Real a_s(unit="m/s")=340.3;/*speed of sound at sea level*/
Real a_1(unit="m/s");/*speed of sound at 10 km altitude*/

Real V_1(unit="m/s",min=0);/*true velocity of the airplane*/
Real V_cal(unit="m/s",min=0);/*calibrated airspeed*/

equation
M_1^2=(2/(gama-1))*((p_0/p_1)^((gama-1)/gama)-1);
a_1=sqrt(gama*R*T_1);
V_1^2=((2*a_1^2)/(gama-1))*((p_0/p_1)^((gama-1)/gama)-1);
V_cal^2=((2*a_s^2)/(gama-1))*((((p_0-p_1)/p_s)+1)^((gama-1)/gama)-1);

end Ex4_17;
