class Ex4_19
/*Vlocity- 60 mi/h=88 ft/s */
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real R(unit="ft.lb/(slug.degR)")=1716;/*Specific Gas Constant of Air*/

parameter Real p_infinite(unit="lb/ft^2")=2116;/*pressure of free stream*/
parameter Real rho_infinite(unit="slug/ft^3")=0.002377;/*density of free stream*/

Real T_infinite(unit="degR");/*temperature of free stream*/
Real a_infinite(unit="ft/s");/*speed of sound through free stream*/

parameter Real V_infinite_miperh(unit="mi/h")=500;/*free-stream speed*/
Real V_infinite(unit="ft/s");/*free-stream speed in foot per second*/
Real M_infinite;/*Mach number of free stream*/

Real T_0_infinite(unit="degR");/*free stream total temperature*/
Real p_0_infinite(unit="lb/ft^2");/*free stream total pressure*/

Real T_0_A(unit="degR");/*total temperature at point A*/
Real p_0_A(unit="lb/ft^2");/*total pressure at point A*/
parameter Real p_A(unit="lb/ft^2")=1497;/*pressure at point A*/

Real M_A(min=0);/*Mach number at point A*/
Real T_A(unit="degR");/*temperature at point A*/
Real a_A(unit="ft/s");/*speed of sound at point A*/
Real V_A(unit="ft/s");/*Velocity at point A*/

equation
T_infinite=p_infinite/(rho_infinite*R);
a_infinite=sqrt(gama*R*T_infinite);
V_infinite=V_infinite_miperh*(88/60);
M_infinite=V_infinite/a_infinite;

T_0_infinite/T_infinite=1+((gama-1)/2)*M_infinite^2;
p_0_infinite/p_infinite=(1+((gama-1)/2)*M_infinite^2)^(gama/(gama-1));

T_0_A=T_0_infinite;
p_0_A=p_0_infinite;

p_0_A/p_A=(1+((gama-1)/2)*M_A^2)^(gama/(gama-1));

T_0_A/T_A=1+((gama-1)/2)*M_A^2;
a_A=sqrt(gama*R*T_A);
V_A=a_A*M_A;

/*The  answer may slightly vary due to  rounding off values*/
end Ex4_19;
