class Ex4_20
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/

parameter Real p_e(unit="N/m^2")=1.01*10^5;/*static pressure at standard sea level*/
parameter Real T_e(unit="K")=288.16;/*static temperature at standard sea level*/
parameter Real M_e=2;/*Mach number of flow at test section*/

Real p_0(unit="N/m^2");/*total pressure at reservior*/
Real T_0(unit="K");/*total temperature at reservior*/

Real A_area_ratio(min=0);/*area ratio A_e/A_t*/

equation
T_0/T_e=1+((gama-1)/2)*M_e^2;
p_0/p_e=(1+((gama-1)/2)*M_e^2)^(gama/(gama-1));
A_area_ratio^2=(1/M_e^2)*((2/(gama+1))*(1+((gama-1)/2)*M_e^2))^((gama+1)/(gama-1));
end Ex4_20;
