class Ex5_17
parameter Real pi = Modelica.Constants.pi;

parameter Real e =0.95;/*span efficiency factor*/
parameter Real e1 =0.95;/*span efficiency factor*/
parameter Real AR=10;/*aspect ratio of the aircraft*/

parameter Real alpha_eff1(unit="deg")=10;/*1st angle of attack*/
parameter Real c_l1=1.2;/*lift coefficient at 10 deg angle of attack*/
parameter Real alpha_eff2(unit="deg")=0;/*2nd angle of attack*/
parameter Real c_l2=0.14;/*lift coefficient at 0 deg angle of attack*/

parameter Real alpha_L_0(unit="deg")=-1.5;/*zero lift angle of angle of attack*/
parameter Real c_d=0.006;/*zero lift profile drag coefficient*/

Real a_0(unit="per deg");/*lift curve slope for an infinite wing*/
Real a(unit="per deg");/*lift curve slope for an finite wing*/

parameter Real alpha(unit="deg")=4;/*angle of attack*/
Real C_L;/*lift coefficient*/
Real C_D;/*totoal drag coefficient*/

equation
a_0=(c_l1-c_l2)/(alpha_eff1-alpha_eff2);
a=a_0/(1+((57.3*a_0)/(pi*e1*AR)));

C_L=a*(alpha-alpha_L_0);

C_D=c_d+(C_L^2/(pi*e*AR));
end Ex5_17;
