class Ex5_19
parameter Real pi = Modelica.Constants.pi;

parameter Real a_0(unit="per deg")=0.106;/*lift curve slope for an infinite wing*/
parameter Real alpha_L_0(unit="deg")=-1.5;/*zero lift angle of angle of attack*/
parameter Real alpha(unit="deg")=2;/*1st angle of attack*/
parameter Real del_alpha(unit="deg")=0.5;/*perturbation in angle of attack*/
Real alpha_n(unit="deg");/*new angle of attack*/
parameter Real e =0.95;/*span efficiency factor*/

/*for aspect ratio 4*/
parameter Real AR_1=4;/*aspect ratio of the aircraft*/

Real a_1(unit="per deg");/*lift curve slope for an finite wing*/
Real C_L_1;/*lift coefficient*/
Real C_L_n1;/*new lift coefficient due to change of angle of attack*/
Real del_C_L_1;/*change in lift coefficient*/

/*for aspect ratio 10*/
parameter Real AR_2=10;/*aspect ratio of the aircraft*/

Real a_2(unit="per deg");/*lift curve slope for an finite wing*/
Real C_L_2;/*lift coefficient*/
Real C_L_n2;/*new lift coefficient due to change of angle of attack*/
Real del_C_L_2;/*change in lift coefficient*/

equation
/*for aspect ratio 4*/
a_1=a_0/(1+((57.3*a_0)/(pi*e*AR_1)));
C_L_1=a_1*(alpha-alpha_L_0);

alpha_n=alpha+del_alpha;
C_L_n1=a_1*(alpha_n-alpha_L_0);

del_C_L_1=C_L_n1-C_L_1;

/*for aspect ratio 10*/
a_2=a_0/(1+((57.3*a_0)/(pi*e*AR_2)));
C_L_2=a_2*(alpha-alpha_L_0);

C_L_n2=a_2*(alpha_n-alpha_L_0);

del_C_L_2=C_L_n2-C_L_2;
end Ex5_19;
