class Ex5_2
parameter Real V_infinite(unit="m/s")=50;/*flow velocity in the test section*/
parameter Real rho_infinite(unit="kg/m^3")=1.225;/*density  flow in the test section*/

Real L(unit="N")=700;/*lift*/
parameter Real c(unit="m")=1.3;/*cord length of airfoil*/
parameter Real s_w(unit="m")=1;/*span of wing*/
Real S(unit="m^2");/*area of wing*/

Real q_infinite(unit="N/m^2");/*dynamics pressure*/
Real c_l;/*lift coefficient of airfoil*/
Real alpha(unit="deg");/*angle of attack*/
Real alpha_L_0(unit="deg");/*zero lift angle of attack*/
equation
/*Number-a*/
S=c*s_w;
q_infinite=(1/2)*rho_infinite*V_infinite^2;
c_l=L/(q_infinite*S);
alpha=1;

/*Number-b*/
alpha_L_0=-2.2;
end Ex5_2;
