class Ex6_18

parameter Real g(unit="ft/s^2")=32.2;/*acceleration due to gravity*/

parameter Real W(unit="lb")=12352;/*normal gross weight*/
parameter Real S(unit="ft^2")=318;/*wing area of the aircraft*/

parameter Real rho_infinite(unit="slug/ft^3")=0.002377;/* atmospheric density*/

parameter Real C_D01=0.02;/*initial zero lift drag coefficient*/
Real C_D0;/*final zero lift drag coefficient*/

parameter Real mu_r=0.4;/*coefficient of rolling friction*/

parameter Real C_L_max=2.5;/*maximum lift coefficient*/
parameter Real L(unit="lb")=0;/*lift*/

Real V_T(unit="ft/s");/*touch down velocity*/
Real V_af(unit="ft/s");/*velocity for average force*/

Real D(unit="lb");/*average drag force*/
Real S_L(unit="ft");/*landing ground roll distance*/
equation
V_T=1.3*sqrt((2*W)/(rho_infinite*S*C_L_max));
V_af=0.7*V_T;

C_D0=C_D01+0.1*C_D01;
D=(1/2)*rho_infinite*V_af^2*S*C_D0;

S_L=(1.69*W^2)/(g*rho_infinite*S*C_L_max*(D+mu_r*(W-L)));

end Ex6_18;
