class Ex6_9
parameter Real W(unit="lb")=2950;/*normal gross weight of aircraft*/
parameter Real S(unit="ft^2")=174;/*wing area*/

parameter Real L_t_D_max=13.6;/*maximum lift to drag ratio*/
parameter Real C_L=0.634;/*Lift coefficient*/

parameter Real rho_infinite_10000(unit="slug/ft^3")=0.0017556;/*atmospheric density at altitude 10000 ft*/
parameter Real rho_infinite_2000(unit="slug/ft^3")=0.0022409;/* atmospheric density at altitude 2000 ft*/

Real theta_max(unit="rad");/*minimum glide angle at radian*/


Real V_infinite_10000(unit="ft/s");/*euilibrium glide velocity at altitude 10000 ft*/
Real V_infinite_2000(unit="ft/s");/*euilibrium glide velocity at altitude 2000 ft*/

equation
theta_max=atan(1/L_t_D_max);

V_infinite_10000=sqrt((2*cos(theta_max)*W)/(rho_infinite_10000*C_L*S));
V_infinite_2000=sqrt((2*cos(theta_max)*W)/(rho_infinite_2000*C_L*S));

/*The  answer may slightly vary due to  rounding off values*/
end Ex6_9;
