class Ex7_3
parameter Real alpha_wb0(unit="deg")=-1.5;/*zero lift angle of attack(geometric angle)*/
parameter Real C_L0=0;/*zero lift coefficient*/

parameter Real alpha_wb1(unit="deg")=5;/*1st angle of attack(geometric angle)*/
parameter Real C_L1=0.52;/*lift coefficient for angle alpha_1*/

parameter Real alpha_wb2(unit="deg")=1;/*2nd angle of attack(geometric angle)*/
parameter Real C_M_cgwb2=-0.01;/*moment coefficient about the center of gravity*/
Real alpha_wb2a(unit="deg");/*2nd angle of attack(absolute angle)*/

parameter Real alpha_wb3(unit="deg")=7.88;/*3rd angle of attack(geometric angle)*/
parameter Real C_M_cgwb3=0.05;/*moment coefficient about the center of gravity*/
Real alpha_wb3a(unit="deg");/*3rd angle of attack(absolute angle)*/

parameter Real h=0.35;/*horizontal coordinate of the center of gravity in fraction of chord length*/
Real h_h_acw;/*horizontal distance between center of gravity and aerodynamic center in fraction of chord length*/
Real h_acwb;/*horizontal distance of aerodynamic center in fraction of chord length*/

Real C_M_acwb;/*moment coefficient about aerodynamic center*/
Real a_wb(unit="per deg");/*lift curve slope*/

equation
a_wb=(C_L1-C_L0)/(alpha_wb1-alpha_wb0);

alpha_wb2a=alpha_wb2+abs(alpha_wb0);
alpha_wb3a=alpha_wb3+abs(alpha_wb0);


C_M_cgwb2=C_M_acwb+a_wb*alpha_wb2a*h_h_acw;
C_M_cgwb3=C_M_acwb+a_wb*alpha_wb3a*h_h_acw;

h_h_acw=h-h_acwb;

end Ex7_3;
