class Ex7_7

parameter Real h_acwb=0.24;/*distance between leading edge and aerodynamic center in fraction of chord length*/
parameter Real h=0.35;/*distance between leading edge and center of gravity in fraction of chord length*/
parameter Real V_H=0.34;/*tail volume ratio*/
parameter Real a_t(unit="per deg")=0.1;/*tail lift slope*/
parameter Real a(unit="per deg")=0.08;/*lift curve slope of wing*/

parameter Real d_eta_d_alpha=0.35;/*rate of change of downwash angle eta w.e.t.angle of attack(alpha)*/
Real h_n;/*neutral pont location in fraction of chord length*/
Real h_n_h;/*static margin in fraction of chord length*/
Real d_C_Mcg_d_alpha_a(unit="per deg");/*slope of the moment coefficient curve*/
equation
h_n=h_acwb+V_H*(a_t/a)*(1-d_eta_d_alpha);
h_n_h=h_n-h;
d_C_Mcg_d_alpha_a=-a*h_n_h;
end Ex7_7;
