class Ex8_3
parameter Real pi = Modelica.Constants.pi;
parameter Real e = Modelica.Constants.e;

/*a*/
parameter Real rho_ib(unit="kg/m^3")=6963;/*density of the iron ball*/
parameter Real r(unit="m")=1/2;/*radius of iron ball(given diameter=1 m)*/
Real v(unit="m^3");/*volume of iron ball*/
Real m(unit="kg");/*mass of iron ball*/
Real S(unit="m^2");/*surface area of iron ball*/

parameter Real C_D=1;/*drag coefficient of iron ball*/
parameter Real g_0(unit="m/s^2")=9.8;/*acceleration due to gravity*/
parameter Real T(unit="K")=288;/*COonstant asmospheric temperature*/
parameter Real R(unit="J/kg.K")=287;/*specific gas constant*/
Real Z(unit="m^(-1)");

parameter Real theta_deg(unit="deg")=15;/*angle of ball velocity direction w.r.t. locaal horizon in degree*/
Real theta(unit="rad");/*angle of ball velocity direction w.r.t. locaal horizon in radian*/

Real rho_md(unit="kg/m^3");/*density corresponding to the maximum deceleration*/
parameter Real rho_0(unit="kg/m^3")=1.225;/*air density at sea level*/
Real h(unit="m");/*altitude at which maximum deceleration occured*/

/*b*/
parameter Real V_E(unit="m/s")=13000;/*entering velocity of ball in m/s unit(given in km/s)*/
Real dV_dt_max(unit="m/s^2");/*maximum deceleration of ball*/
Real dV_dt_max_g(unit="m/s^2");/*maximum deceleration of ball in terms of acceleration due to gravity*/

/*c*/
Real V(unit="m/s");/*impact velocity of ball on earth surface*/
parameter Real a_s(unit="m/s")=340.9;/*speed of sound at sea level*/
Real M;/*Mach number at impact*/

equation
/*a*/
v=(4/3)*pi*r^3;
S=pi*r^2;
m=rho_ib*v;
Z=g_0/(R*T);
theta=Modelica.SIunits.Conversions.from_deg(theta_deg);
rho_md=(m/(C_D*S))*Z*sin(theta);
rho_md/rho_0=exp(-Z*h);

/*b*/
dV_dt_max=(V_E^2*Z*sin(theta))/(2*e);
dV_dt_max_g=dV_dt_max/g_0;

/*c*/
V/V_E=exp(-rho_0/(2*(m/(C_D*S))*Z*sin(theta)));
M=V/a_s;

/*The  answer may slightly vary due to  rounding off values*/
end Ex8_3;
