class Ex9_2
/*pressure conversion 1 atm=1.01*10^5 N/m^2;*/

parameter Real pi = Modelica.Constants.pi;

parameter Real b(unit="cm")=9;/*bore length*/
parameter Real s(unit="cm")=9.5;/*stroke of the engine*/
parameter Real N=6;/*number of cylinder*/
parameter Real eta=0.83;/*propeller efficiency*/
parameter Real eta_mechanical=0.75;/*mechanical efficiency of the engine*/
parameter Real rpm(unit="rpm")=3000;/*propeller revolution in per minute*/

Real d_cm3(unit="cm^3");/*displacement in cm^3*/
Real d(unit="m^3");/*displacement in m^3*/

parameter Real P_4(unit="N/m^2")=103366;/*pressure after constant-volume combustion*/ 
Real P_e_SI(unit="N/m^2");/*effective pressure in SI unit*/
Real P_e(unit="atm");/*effective pressure in atm*/
equation
d_cm3=((pi*b^2)/4)*s*N;
d=d_cm3*10^(-6);

P_4=(1/120)*eta*eta_mechanical*rpm*d*P_e_SI;
P_e=P_e_SI/(1.01*10^5);

/*The  answer may slightly vary due to  rounding off values*/
end Ex9_2;
