class Ex9_4
/*a*/
parameter Real R_bar(unit="J/(kg mo)(K)")=8314;/*universal gas constant*/
Real R(unit="J/kg.K");/*specific gas constant*/
parameter Real M_bar=16;/*molecular weight*/
parameter Real gama=1.22;/*ratio of specific heat at constant pressure and specific heat at constant volume*/

parameter Real P_infinite(unit="atm")=1.174*10^(-2);/*atmospheric pressure at 30 km altitude*/
parameter Real g_0(unit="m/s^2")=9.8;/*acceleration due to gravity*/
parameter Real T_0(unit="K")=3517;/*combustion chamber temperature*/
parameter Real P_0(unit="atm")=25;/*combustion chamber pressure*/

Real P_0_SI(unit="N/m^2");/*combustion chamber pressure in SI unit*/
Real P_e(unit="atm");/*exit pressure*/
Real I_sp(unit="s");/*specific impulse*/
/*b*/
parameter Real A_star(unit="m^2")=0.1;/*nozzle throat area*/
Real m_dot(unit="kg/s");/*mass flow rate*/ 
Real T_e(unit="K");/*exit temperature*/
Real c_p(unit="J/(kg*K)");/*specific heat at constant pressure*/
Real V_e(unit="m/s");/*exit velocity*/
Real T(unit="N");/*thrust*/
Real T_lb(unit="lb");/*thrust in lb*/

/*c*/
Real rho_e(unit="kg/m^3");/*density at exit*/
Real A_e(unit="m^2");/*exit area*/

/*c*/
Real a_e(unit="m/s");/*sound of speed at exit*/
Real M_e;/*Mach number at exit*/
equation
/*a*/ 
R=R_bar/M_bar;
P_e=P_infinite;
I_sp=(1/g_0)*sqrt(((2*gama*R_bar*T_0)/((gama-1)*M_bar))*(1-(P_e/P_0)^((gama-1)/gama)));

/*b*/
P_0_SI=P_0*1.01*10^5;
m_dot=((P_0_SI*A_star)/sqrt(T_0))*sqrt((gama/R)*(2/(gama+1))^((gama+1)/(gama-1)));
T_e/T_0=(P_e/P_0)^((gama-1)/gama);
c_p=(gama*R)/(gama-1);
V_e=sqrt(2*c_p*(T_0-T_e));
T=m_dot*V_e;
T_lb=T*0.2247;

/*c*/
rho_e=(P_e*101325)/(R*T_e);/*here101325 has been multiplied with P_e to convert the unit from atm to N/m^2*/ 
m_dot=rho_e*A_e*V_e;

/*d*/
a_e=sqrt(gama*R*T_e);
M_e=V_e/a_e;

/*The  answer may slightly vary due to  rounding off values*/
end Ex9_4;
