class Ex10_1
parameter Real pi = Modelica.Constants.pi;

parameter Real d(unit="in")=0.75;/*diameter of the rod*/
parameter Real l(unit="in")=100;/*length of the rod*/
Real A(unit="in^2");/*cross sectional area of the rod*/
parameter Real F(unit="lb")=12000;/*tensile load on the rod*/
parameter Real E(unit="lb/in^2")=29*10^6;/*Young Modulus*/
Real sigma(unit="lb/in^2");/*tensile stress*/
Real epsilon;/*strain on the road*/
Real delta_l(unit="in");/*elongation of the road*/
equation
A=(pi*d^2)/4;
sigma=F/A;
sigma=E*epsilon;/*Hook's Law*/
delta_l=epsilon*l;
end Ex10_1;
