class Ex4_12
parameter Real T_star(unit="K")=833;/*Air temperature at throat*/
parameter Real T_exit(unit="K")=300;/*Air temperature at exit*/

parameter Real V_star(unit="m/s")=580;/*velocity at throat*/
parameter Real V_exit(unit="m/s")=1188;/*velocity at exit*/

Real a_star(unit="m/s");/*speed of sound at throat*/
Real a_exit(unit="m/s");/*speed of sound at throat*/

Real M_star;/*Mach number at throat*/
Real M_exit;/*Mach number at exit*/

parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real R(unit="J/kg*K")=287;/*Specific Gas Constant of Air*/

equation
a_star=sqrt(gama*R*T_star);
M_star=V_star/a_star;

a_exit=sqrt(gama*R*T_exit);
M_exit=V_exit/a_exit;
end Ex4_12;
