class Ex4_27
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real R(unit="ft.lb/(slug.degR)")=1716;/*Specific Gas Constant of Air*/

parameter Real x(unit="ft")=2;/*distance from leading edge*/
parameter Real M_infinite=2;/*Mach number of aircraft*/

parameter Real rho_infinite(unit="slug/ft^3")=7.382*10^(-4);/*air density at 35000ft*/
parameter Real T_infinite(unit="degR")=394.08;/*air Temperature at 35000ft*/

Real a_infinite(unit="ft/s");/*speed of sound at 35000ft*/
Real V_infinite(unit="ft/s");/*Velocity of freestream at 35000ft*/

parameter Real mu_infinite(unit="slug/ft.s")=2.82*10^(-7);/*viscosity of freestream*/
Real Re_x;/*Reynolds Number*/

Real c_fx_inc;/*incompressible skin friction coefficient*/
Real c_fx;/*turbulent skin friction coefficient*/

Real q_infinite(unit="lb/ft^2");/*dynamics pressure*/

Real tau_w(unit="lb/ft^2");/*shear stress at 2ft*/

equation
a_infinite=sqrt(gama*R*T_infinite);
V_infinite=a_infinite*M_infinite;
Re_x=(rho_infinite*V_infinite*x)/mu_infinite;
c_fx_inc=0.0592/Re_x^0.2;
c_fx/c_fx_inc=0.74;
q_infinite=(1/2)*rho_infinite*V_infinite^2;
tau_w=q_infinite*c_fx;
end Ex4_27;
