class Ex4_6
parameter Real c_v_1(unit="J/(kg*K)")=720;/*specific heat at constant volume-SI Units*/
parameter Real c_v_2(unit="(ft.lb)/(slug.degR)")=4290;/*specific heat at constant volume-English Engineering Units*/

parameter Real c_p_1(unit="J/(kg*K)")=1008;/*specific heat at constant pressure-SI Units*/
parameter Real c_p_2(unit="(ft.lb)/(slug.degR)")=6006;/*specific heat at constant pressure-English Engineering Units*/

parameter Real T_1(unit="K")=288;/*Air temperature at standard sea level-SI Unit*/
parameter Real T_2(unit="degR")=519;/*Air temperature at standard sea level-English Engineering Units*/

/*Number-a*/
Real e_1(unit="J/kg");/*internal energy-SI Units*/
Real h_1(unit="J/kg");/*enthalpy-SI Units*/

/*Number-b*/
Real e_2(unit="ft.lb/slug");/*internal energy-English Engineering Units*/
Real h_2(unit="ft.lb/slug");/*enhalpy-English Engineering Units*/
equation
/*Number-a*/
e_1=c_v_1*T_1;
h_1=c_p_1*T_1;

/*Number-b*/
e_2=c_v_2*T_2;
h_2=c_p_2*T_2;
end Ex4_6;
