class Ex5_18
/*velocity- 60 mi/h=88 ft/s;*/
parameter Real pi = Modelica.Constants.pi;

parameter Real e =0.93;/*span efficiency factor*/

parameter Real b(unit="ft")=40.33;/*wingspan of the airplane*/
parameter Real S(unit="ft^2")=255;/*planform area of each wing*/
Real AR;/*aspect ratio of each wing*/

parameter Real L(unit="lb")=750;/*total lift on wing*/
Real L_1(unit="lb");/*lift on each wing*/

parameter Real V_infinite(unit="mi/h")=30;/*flight velocity of aircraft*/
Real V_infinite_fps(unit="ft/s");/*flight velocity of aircraft in fps system*/

parameter Real rho_infinite(unit="lb/ft^3")=0.002377;/* atmospheric density*/
Real q_infinite(unit="lb/ft^2");/*dynamics pressure*/

Real C_L;/*lift coefficient of each wing*/
Real C_Di;/*induced drag coefficient of each wing*/
Real D_i(unit="lb");/*induced drag of each wing*/
Real D_it(unit="lb");/*induced drag for both wing*/

equation
V_infinite_fps=V_infinite*(88/60);
q_infinite=(1/2)*rho_infinite*V_infinite_fps^2;

L_1=L/2;
C_L=L_1/(q_infinite*S);

AR=b^2/S;

C_Di=C_L^2/(pi*e*AR);
D_i=q_infinite*S*C_Di;

D_it=2*D_i;
end Ex5_18;
