class Ex5_21
/*velocity- 60 mi/h=88 ft/s;*/

parameter Real rho_infinite(unit="slug/ft^3")=0.002377;/* atmospheric density*/
parameter Real S(unit="ft^2")=1650;/*wing planform area*/
parameter Real C_L_max=3;/*maximum lift coefficient*/

parameter Real W(unit="lb")=160000;/*weight of aircraft*/

Real V_stall_fps(unit="ft/s");/*flight velocity of aircraft  in fps units*/
Real V_stall(unit="mi/h");/*flight velocity of aircraft in miles per hour*/

equation
V_stall_fps=sqrt((2*W)/(rho_infinite*S*C_L_max));
V_stall=V_stall_fps*(60/88);
end Ex5_21;
