class Ex6_17
parameter Real pi = Modelica.Constants.pi;

parameter Real g(unit="ft/s^2")=32.2;/*acceleration due to gravity*/

parameter Real W(unit="lb")=19815;/*normal gross weight*/
parameter Real b(unit="ft")=53.3;/*wingspan of the aircraft*/
parameter Real S(unit="ft^2")=318;/*wing area of the aircraft*/
parameter Real AR=8.93;/*Aspect Ratio*/
parameter Real e=0.81;/*span efficiency factor*/
parameter Real h(unit="ft")=6;/*the distance between ground and wings*/
Real phi;/*ground effector factor*/

parameter Real C_D0=0.02;/*zero lift drag coefficient*/
parameter Real mu_r=0.02;/*coefficient of rolling friction*/
parameter Real C_L_max=1;/*maximum lift coefficient*/
parameter Real C_L=1;/*lift coefficient*/

parameter Real rho_infinite(unit="slug/ft^3")=0.002377;/* atmospheric density*/
parameter Real T(unit="lb")=7300;/*thrust available from the engine at sea level*/

Real V_LO(unit="ft/s");/*lift off speed*/
Real V_af(unit="ft/s");/*velocity for average force*/
Real L(unit="lb");/*average lift force*/
Real D(unit="lb");/*average drag force*/
Real S_LO(unit="ft");/*liftoff distance*/

equation
phi=((16*h)/b)^2/(1+((16*h)/b)^2);
V_LO=1.2*sqrt((2*W)/(rho_infinite*S*C_L_max));
V_af=0.7*V_LO;
L=(1/2)*rho_infinite*V_af^2*S*C_L_max;
D=(1/2)*rho_infinite*V_af^2*S*(C_D0+phi*(C_L^2/(pi*e*AR)));
S_LO=(1.44*W^2)/(g*rho_infinite*S*C_L_max*(T-(D+mu_r*(W-L))));

/*The  answer provided in the textbook is wrong*/
end Ex6_17;
