class Ex7_5

parameter Real C_M_acwb=-0.032;/*moment coefficient about aerodynamic center*/
parameter Real a(unit="per deg")=0.08;/*lift curve slope of wing*/

parameter Real h_h_acwb=0.11;/*horizontal distance between center of gravity and aerodynamic center in fraction of chord length*/

parameter Real V_H=0.34;/*tail volume ratio*/
parameter Real a_t(unit="per deg")=0.1;/*tail lift slope*/
parameter Real d_eta_d_alpha=0.35;/*rate of change of downwash angle eta w.e.t.alpha*/
parameter Real i_t(unit="deg")=2.7;/*tail setting angle*/
parameter Real eta_0=0;/*zero lift downwash angle*/

Real d_C_Mcg_d_alpha_a(unit="per deg");/*slope of the moment coefficient curve*/
Real C_M0;/*moment coefficient about center of gravity at zero lift*/
Real alpha_e(unit="deg");/*equilibrium angle of attack*/
equation
d_C_Mcg_d_alpha_a=a*(h_h_acwb-V_H*(a_t/a)*(1-d_eta_d_alpha));

C_M0=C_M_acwb+V_H*a_t*(i_t+eta_0);
0=C_M0+d_C_Mcg_d_alpha_a*alpha_e;
end Ex7_5;
