class Ex7_9
parameter Real d_C_he_d_alpha_t(unit="per deg")=-0.008;/*rate of change of elevator hinge moment coefficient w.r.t. angle of atack of tail*/
parameter Real d_C_he_d_del_e(unit="per deg")=-0.013;/*rate of change of elevator hinge moment coefficient w.r.t. elevator deflection angle*/

parameter Real a_t(unit="per deg")=0.1;/*tail lift slope*/
parameter Real d_C_Lt_d_del_e(unit="per deg")=0.04;/*tail lift curve slope*/
Real F;/*free elevator factor*/

parameter Real C_M_acwb=-0.032;/*moment coefficient about aerodynamic center*/
parameter Real V_H=0.34;/*tail volume ratio*/
parameter Real i_t(unit="deg")=2.7;/*tail setting angle*/
parameter Real eta_0=0;/*zero lift downwash angle*/
Real C_M0_das;/*zero lift moment cofficient*/

parameter Real h_acwb=0.24;/*distance between leading edge and aerodynamic center in fraction of chord length*/
parameter Real d_eta_d_alpha=0.35;/*rate of change of downwash angle eta w.e.t.alpha*/
parameter Real a(unit="per deg")=0.08;/*lift slope*/
Real h_n_das;/*neutral pont location in fraction of chord length*/

parameter Real h=0.35;/*distance between leading edge and center of gravity in fraction of chord length*/
Real d_C_Mcg_d_alpha_a(unit="per deg");/*slope of the moment coefficient curve*/

equation
F=1-(1/a_t)*d_C_Lt_d_del_e*(d_C_he_d_alpha_t/d_C_he_d_del_e);

C_M0_das=C_M_acwb+F*V_H*a_t*(i_t+eta_0);

h_n_das=h_acwb+F*V_H*(a_t/a)*(1-d_eta_d_alpha);

d_C_Mcg_d_alpha_a=-a*(h_n_das-h);

end Ex7_9;
