class Ex9_1
/*power conversion 1 hp=746 J/s */
/*pressure conversion 1 atm=1.01*10^5 N/m^2;*/

parameter Real pi = Modelica.Constants.pi;
parameter Real R(unit="J/kg.K")=288;/*specific gas constant*/
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
Real c_v(unit="J/(kg*K)");/*specific heat at constant volume*/
parameter Real c_p(unit="J/(kg*K)")=1008;/*specific heat at constant pressure*/
parameter Real C_R=10;/*compression ratio*/
 
Real x(unit="cm");/*distance from the top of the cylinder to the piston top dead center position*/
parameter Real b(unit="cm")=9;/*bore length*/
Real V_2_cm(unit="cm^3");/*Volume after intake stroke in cm^3*/

Real V_2(unit="m^3");/*Volume after intake stroke*/
parameter Real P_2(unit="atm")=0.8;/*pressure in the intake mainfold*/
parameter Real T_2(unit="K")=250;/*temperature in the intake mainfold*/

Real V_3(unit="m^3");/*Volume after compresssion stroke*/
Real P_3(unit="atm");/*pressure after compresssion stroke*/
Real T_3(unit="K");/*temperature after compresssion stroke*/

Real V_4(unit="m^3");/*Volume after constant-volume combustion*/
Real P_4(unit="atm");/*pressure after constant-volume combustion*/
Real T_4(unit="K");/*temperature after constant-volume combustion*/

Real V_5(unit="m^3");/*Volume after power stroke*/
Real P_5(unit="atm");/*pressure after power stroke*/
//Real T_5(unit="K");/*temperature after power stroke*/

parameter Real E_R(unit="J/kg")=4.29*10^7;/*energy release by per kilogram of gasoline*/
Real q(unit="J/kg");/*energy release by per kilogram of fuel-air mixture*/

Real W_com(unit="J");/*work done on compression stroke*/
Real W_pow(unit="J");/*work done by the power stroke*/
Real W(unit="J");/*net work per cycle*/

parameter Real eta=0.83;/*propeller efficiency*/
parameter Real eta_mechanical=0.75;/*mechanical efficiency of the engine*/
parameter Real rpm(unit="rpm")=3000;/*propeller revolution in per minute*/
parameter Real N=6;/*number of cylinder*/

Real P_A(unit="J/s");/*total power available from the engine-propeller combination in J/s unit*/
Real hp_A(unit="hp");/*total power available from the engine-propeller combination in horse power unit*/
equation
(x+9.5)/x=10;
V_2_cm=((pi*b^2)/4)*(x+9.5);
V_2=V_2_cm*10^(-6);

V_2/V_3=C_R;
P_3/P_2=(V_2/V_3)^gama;
T_3/T_2=(V_2/V_3)^(gama-1);

q=(E_R*0.06)/1.06;
c_v=c_p-R;
T_4=(q/c_v)+T_3;
P_4/P_3=T_4/T_3;

V_2=V_5;
V_3=V_4;

P_5/P_4=(V_4/V_5)^gama;

W_com=((P_2*V_2-P_3*V_3)/(1-gama))*1.01*10^5;/*here W_com has been multiplied by 1.01*10^5 to convert from pressure from atm to N/m^2*/
W_pow=((P_5*V_5-P_4*V_4)/(1-gama))*1.01*10^5;/*here W_pow has been multiplied by 1.01*10^5 to convert from pressure from atm to N/m^2*/
W=W_pow-W_com;

P_A=(eta*eta_mechanical*rpm*N*W)/120;
hp_A=P_A/746;

/*The  answer may slightly vary due to  rounding off values*/
end Ex9_1;
