class Ex9_3
/*velocity conversion 60 mi/h=88 ft/s,*/

parameter Real V_infinite1(unit="mi/h")=500;/*free stream velocity in mile per hour*/
Real V_infinite(unit="ft/s");/*free stream velocity in foot per second*/

parameter Real P_infinite(unit="lb/ft^2")=629.66;/*free stream pressure at 30000 ft*/
parameter Real rho_infinite(unit="slug/ft^3")=8.9068*10^(-4);/*free stream density at 30000 ft*/

parameter Real A_i(unit="ft^2")=7;/*inlet area*/
parameter Real A_e(unit="ft^2")=4.5;/*exit area*/

parameter Real V_e(unit="ft/s")=1600;/*velocity of the exit gas*/
parameter Real P_e(unit="lb/ft^2")=640;/*pressure of the exit gas*/

Real m_dot_air(unit="slugs/s");/*mass flow rate through exit*/
Real T(unit="lb");/*thrust of the turbojet*/
equation
V_infinite=V_infinite1*(88/60);

m_dot_air=rho_infinite*V_infinite*A_i;

T=m_dot_air*(V_e-V_infinite)+(P_e-P_infinite)*A_e;
/*The  answer may slightly vary due to  rounding off values*/
end Ex9_3;
