class Ex9_5
parameter Real g_0(unit="m/s^2")=9.8;/*acceleration due to gravity*/
parameter Real I_sp(unit="s")=350;/*specific impulse of the rocket*/
parameter Real M_L(unit="kg")=50;/*mass of the payload of the rocket*/

/*single stage rocket*/
parameter Real M_p(unit="kg")=4450;/*mass of the propellant of the single stage rocket*/
parameter Real M_s(unit="kg")=500;/*structural mass of the single stage rocket*/
Real M_i(unit="kg");/*initial mass of the single stage rocket*/
Real M_f(unit="kg");/*final mass of the single stage rocket*/
Real V_b(unit="m/s");/*burnout velocity of the single stage rocket*/

/*double stage rocket*/

parameter Real M_p1(unit="kg")=3450;/*1st stage mass of the propellant of the double stage rocket*/
parameter Real M_p2(unit="kg")=1000;/*2nd stage mass of the propellant of the double stage rocket*/

parameter Real M_s1(unit="kg")=400;/*1st stage structural mass of the double stage rocket*/
parameter Real M_s2(unit="kg")=100;/*2nd stage structural mass of the double stage rocket*/

Real V_b1(unit="m/s");/*1st stage burnout velocity of the double stage rocket*/
Real V_b2(unit="m/s");/*2nd stage burnout velocity of the double stage rocket*/

equation
/*single stage rocket*/
M_i=M_p+M_s+M_L;
M_f=M_s+M_L;
V_b=g_0*I_sp*log(M_i/M_f);

/*double stage rocket*/
V_b1=g_0*I_sp*log((M_p1+M_s1+M_p2+M_s2+M_L)/(M_s1+M_p2+M_s2+M_L));
V_b2-V_b1=g_0*I_sp*log((M_p2+M_s2+M_L)/(M_s2+M_L));

/*The  answer may slightly vary due to  rounding off values*/
end Ex9_5;
