class Ex4_16
parameter Real R(unit="ft.lb/(slug.degR)")=1716;/*Specific Gas Constant of Air*/
parameter Real p(unit="lb/ft^2")=1761;/*standard atmospheric pressure*/
parameter Real p_0(unit="lb/ft^2")=1818;/*total pressure*/
parameter Real T(unit="degR")=505;/*outside air temperature*/
parameter Real rho_s(unit="slug/ft^3")=2.377*10^(-3);//*standard sea level air density*/
Real rho(unit="slug/ft^3");/*ambient air density at 5000 ft*/
Real V_true(unit="ft/s");/*true velocity of the airplane*/
Real V_e(unit="ft/s");/*equivalent airspeed*/
equation
rho=p/(R*T);
V_true=sqrt((2*(p_0-p))/rho);
V_e=sqrt((2*(p_0-p))/rho_s);
end Ex4_16;
