class Ex4_18
/*Vlocity- 60 mi/h=88 ft/s */
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real R(unit="ft.lb/(slug.degR)")=1716;/*Specific Gas Constant of Air*/
parameter Real p_1(unit="lb/ft^2")=151;/*ambient pressure of air*/
Real T_1(unit="degR")=390;/*ambient temperature of air*/
Real a_1(unit="ft/s");/*speed of sound*/
Real M_1;/*Mach number of aircraft*/
parameter Real V_1_miperh(unit="mi/h")=3000;/*velocity of the aircraft*/
Real V_1(unit="ft/s");/*velocity in fps of the aircraft*/


Real p_02(unit="lb/ft^2");/*pressure measured by pitot tube*/ 
equation
a_1=sqrt(gama*R*T_1);
V_1=V_1_miperh*(88/60);
M_1=V_1/a_1;
p_02/p_1=(((((gama+1)^2)*M_1^2)/(4*gama*M_1^2-2*(gama-1)))^(gama/(gama-1)))*((1-gama+2*gama*M_1^2)/(gama+1));
/*The  answer may slightly vary due to  rounding off values*/

end Ex4_18;
