class Ex4_21
/*pressure 1 atm=2116 lb/ft^2*/
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real R(unit="ft.lb/(slug.degR)")=1716;/*Specific Gas Constant of Air*/

parameter Real p_0_atm(unit="atm")=10;/*reservior pressure at atm unit*/ 
Real p_0(unit="lb/ft^2");/*reservior pressure in fps system*/

parameter Real T_0(unit="degR")=600;/*reservior temperature*/
parameter Real M_e=3;/*Mach number of the at text/exit section*/
 
Real p_e(unit="lb/ft^2");/*exit pressure*/

Real p_stag(unit="lb/ft^2");/*pressure at stagnation point*/
Real T_stag(unit="degR");/*temperature at stagnation point*/
Real rho_stag(unit="slug/ft^3");/*density at stagnation point*/
equation
p_0=p_0_atm*2116;
p_e=p_0*(1+((gama-1)/2)*M_e^2)^(-gama/(gama-1));

p_stag/p_e=(((((gama+1)^2)*M_e^2)/(4*gama*M_e^2-2*(gama-1)))^(gama/(gama-1)))*((1-gama+2*gama*M_e^2)/(gama+1));

T_stag=T_0;
rho_stag=p_stag/(R*T_stag);
end Ex4_21;
