class Ex4_22
/*pressure- 1 atm=1.01*10^5 N/m^2*/
parameter Real gama=1.26;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real R(unit="J/kg*K")=378;/*Specific Gas Constant of Mixture*/

parameter Real p_0(unit="atm")=20;/*pressure at the combustion chamber*/
Real p_0_SI(unit="N/m^2");/*pressure at the combustion chamber in SI unit*/
parameter Real T_0(unit="K")=3144;/*temperature at the combustion chamber*/

parameter Real p_e(unit="atm")=1;/*pressure at exit*/
Real T_e(unit="K");/*temperature at exit*/

Real a_e(unit="m/s");/*speed of sound at exit*/
Real M_e(min=0);/*Mach number at exit*/
Real V_e(unit="m/s");/*velocity at exit*/

Real p_star(unit="N/m^2");/*pressure at throat*/
Real T_star(unit="K");/*temperature at throat*/
Real a_star(unit="m/s");/*speed of sound at throat*/
Real rho_star(unit="kg/m^3");/*density at throat*/

parameter Real A_star(unit="m^2")=0.1;/*throat cross section area*/
parameter Real M_star=1;/*Mach number at throat*/
Real V_star(unit="m/s");/*velocity at throat*/

Real m_dot(unit="kg/s");/*mass flow through the nozzle*/
equation
/*Number-a*/
p_e/p_0=(T_e/T_0)^(gama/(gama-1));
a_e=sqrt(gama*R*T_e);
T_0/T_e=1+((gama-1)/2)*M_e^2;
V_e=M_e*a_e;

/*Number-b*/
p_0_SI=p_0*1.01*10^5;

p_0_SI/p_star=(1+((gama-1)/2)*M_star^2)^(gama/(gama-1));
T_0/T_star=1+((gama-1)/2)*M_star^2;
a_star=sqrt(gama*R*T_star);
rho_star=p_star/(R*T_star);

V_star=M_star*a_star;
m_dot=rho_star*A_star*V_star;
end Ex4_22;
