class Ex4_23
parameter Real x(unit="cm")=5;/*length of plate*/
Real x_SI(unit="m");/*length of plate in SI units*/
parameter Real V_infinite(unit="m/s")=120;/*freestream velocity*/
parameter Real rho_infinite(unit="kg/m^3")=1.225;/*freestream density*/
parameter Real mu_infinite(unit="kg/m.s")=1.789*10^(-5);/*viscosity of freestream*/
Real Re_x;/*Reynolds Number*/
Real del(unit="m");/*boundary layer thickness at the downstream edge*/
Real Re_L;/*Reynolds Number at L*/
Real C_f;/*skin friction drag coefficient*/
Real q_infinite(unit="N/m^2");/*dynamics pressure*/
parameter Real w(unit="m")=1;/*wide of the plate*/
Real S(unit="m^2");/*surface area*/
Real D_f_top(unit="N");/*drag on the top surface*/
Real D_f(unit="N");/*drag on the whole surface*/
equation
/*Number-a*/
x_SI=x/100;
Re_x=(rho_infinite*V_infinite*x_SI)/mu_infinite;
del=(5.2*x_SI)/sqrt(Re_x);

/*Number-b*/
Re_L=Re_x;
C_f=1.328/sqrt(Re_L);
q_infinite=(1/2)*rho_infinite*V_infinite^2;
S=x_SI*w;
D_f_top=q_infinite*S*C_f;
D_f=2*D_f_top;

end Ex4_23;
