class Ex4_25
parameter Real x(unit="m")=0.05;/*length of plate*/
parameter Real Re_x=4.11*10^5;/*Reynolds number*/

Real del(unit="m");/*laminar boundary layer*/

Real C_f;/*skin friction drag coefficient*/

parameter Real q_infinite(unit="N/m^2")=8820;/*dynamics pressure*/
parameter Real S(unit="m^2")=0.05;/*surface area*/

Real D_f_top(unit="N");/*drag on the top surface*/
Real D_f(unit="N");/*drag on the whole surface*/

equation
del=(0.37*x)/Re_x^0.2;

C_f=0.074/Re_x^0.2;

D_f_top=q_infinite*S*C_f;
D_f=2*D_f_top;
end Ex4_25;
