class Ex4_4
parameter Real p_1(unit="N/m^2")=1.2*10^5;/*pressure at the inlet of the duct*/
parameter Real T_1(unit="K")=330;/*Temperature at the inlet of the duct*/
parameter Real V_1(unit="m/s")=10;/*velocity at the inlet of the duct*/

Real rho(unit="kg/m^3");/*density of air*/

Real p_2(unit="N/m^2");/*pressure at the exit of the duct*/
parameter Real V_2(unit="m/s")=30;/*velocity at the inlet of the duct*/

parameter Real R(unit="J/(kg.K)")=287;/*Specific Gas Constant of Air*/

equation
rho=p_1/(R*T_1);
p_1+(rho*V_1^2)/2=p_2+(rho*V_2^2)/2;
end Ex4_4;
