class Ex4_9
parameter Real c_p(unit="J/(kg*K)")=1008;/*specific heat at constant pressure*/
parameter Real T_0(unit="K")=1000;/*temperature in the reservoir*/
parameter Real T_star(unit="K")=833;/*temperature at the throat*/
parameter Real T_e(unit="K")=300;/*temperature at the exit*/
parameter Real V_0(unit="m/s")=0;/*velocity in the reservoir*/
Real V_star(unit="m/s",min=0);/*velocity at the throat*/
Real V_e(unit="m/s",min=0);/*velocity at the exit*/

parameter Real m_dot(unit="kg/s")=0.5;/*mass flow rate*/
parameter Real p_0(unit="atm")=10;/*pressure in the reservoir in standard atmosphere*/
Real p_0_SI(unit="N/m^2");/*pressure in the reservoir in SI units*/
parameter Real R(unit="J/(kg.K)")=287;/*Specific Gas Constant of Air*/
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
Real rho_0(unit="kg/m^3");/*density in the reservoir*/
Real rho_star(unit="kg/m^3");/*density in the throat*/
Real A_star(unit="m^2");/*area of the throat*/

Real rho_e(unit="kg/m^3");//*density in the exit*/
Real A_e(unit="m^2");/*area of the exit*/

equation
/*Number-a*/
c_p*T_0+(1/2)*V_0^2=c_p*T_star+(1/2)*V_star^2;

/*Number-b*/
c_p*T_0+(1/2)*V_0^2=c_p*T_e+(1/2)*V_e^2;

/*Number-c*/
p_0_SI=p_0*1.01*10^5;
rho_0=p_0_SI/(R*T_0);
rho_star/rho_0=(T_star/T_0)^(1/(gama-1));
m_dot=rho_star*A_star*V_star;

/*Number-d*/
rho_e=rho_0*(T_e/T_0)^(1/(gama-1));
m_dot=rho_e*A_e*V_e;
end Ex4_9;
