class Ex5_12
/*force 1kgf=9.8 N*/ 
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real R(unit="J/(kg.K)")=287;/*Specific Gas Constant of Air*/

parameter Real M_infinite=2;/*Mach number of the aircraft*/
parameter Real S(unit="m^2")=19.5;/*wing planform area*/
parameter Real W_1(unit="kgf")=7262;/*weight of aircraft in kgf*/
Real W(unit="N");/*weight of aircraft in SI units*/
Real L(unit="N");/*lift of aircraft*/

/*at sea level*/
parameter Real rho_infinite1(unit="kg/m^3")=1.23;/*atmospheric density at sea level*/
parameter Real T_infinite1(unit="K")=288;/*atmospheric Temperature at sea level*/

Real a_infinite1(unit="m/s");/*speed of sound at sea level*/
Real V_infinite1(unit="m/s");/*velocity of the aircraft at sea level*/
Real q_infinite1(unit="N/m^2");/*dynamics pressure at sea level*/

Real c_l_1;/*lift coefficient at sea level*/
Real alpha_rad1(unit="rad");/*angle of attack of the airfoil at sea level*/
Real alpha1(unit="deg");/*angle of attack of the airfoil in degree at sea level*/

/*at 10km altitude*/
parameter Real rho_infinite2(unit="kg/m^3")=0.41351;/*atmospheric density at 10km altitude*/
parameter Real T_infinite2(unit="K")=223.26;/*atmospheric Temperature at 10km altitude*/

Real a_infinite2(unit="m/s");/*speed of sound at 10km altitude*/
Real V_infinite2(unit="m/s");/*velocity of the aircraft at 10km altitude*/
Real q_infinite2(unit="N/m^2");/*dynamics pressure at 10km altitude*/

Real c_l_2;/*lift coefficient at 10km altitude*/
Real alpha_rad2(unit="rad");/*angle of attack of the airfoil at 10km altitude*/
Real alpha2(unit="deg");/*angle of attack of the airfoil in degree at 10km altitude*/
equation
/*Number-a*/
W=W_1*9.8;
L=W;
/*at sea level*/
a_infinite1=sqrt(gama*R*T_infinite1);
V_infinite1=a_infinite1*M_infinite;
q_infinite1=(1/2)*rho_infinite1*V_infinite1^2;
c_l_1=L/(q_infinite1*S);
c_l_1=4*alpha_rad1/sqrt(M_infinite^2-1);
alpha1=Modelica.SIunits.Conversions.to_deg(alpha_rad1);

/*Number-b*/
/*at 10km altitude*/
a_infinite2=sqrt(gama*R*T_infinite2);
V_infinite2=a_infinite2*M_infinite;
q_infinite2=(1/2)*rho_infinite2*V_infinite2^2;
c_l_2=L/(q_infinite2*S);
c_l_2=4*alpha_rad2/sqrt(M_infinite^2-1);
alpha2=Modelica.SIunits.Conversions.to_deg(alpha_rad2);

/*The  answer may slightly vary due to  rounding off values*/
end Ex5_12;
