class Ex5_13
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real R(unit="J/(kg.K)")=287;/*Specific Gas Constant of Air*/

parameter Real M_infinite=2;/*Mach number of the aircraft*/
parameter Real S(unit="m^2")=19.5;/*wing planform area*/
parameter Real W_1(unit="kgf")=7262;/*weight of aircraft in kgf*/
Real W(unit="N");/*weight of aircraft in SI units*/
Real L(unit="N");/*lift of aircraft*/
Real lift_to_drag_ratio;/*ratio of lift and drag*/ 

parameter Real rho_infinite(unit="kg/m^3")=0.41351;/*atmospheric density at 10km altitude*/
parameter Real T_infinite(unit="K")=223.26;/*atmospheric Temperature at 10km altitude*/

Real a_infinite(unit="m/s");/*speed of sound at 10km altitude*/
Real V_infinite(unit="m/s");/*velocity of the aircraft at 10km altitude*/
Real q_infinite(unit="N/m^2");/*dynamics pressure at 10km altitude*/

Real c_l;/*lift coefficient at 10km altitude*/
Real alpha(unit="rad");/*angle of attack of the airfoil at 10km altitude*/
Real alpha_deg(unit="deg")=10;/*angle of attack of the airfoil in degree at 10km altitude*/
equation
W=W_1*9.8;

alpha=Modelica.SIunits.Conversions.from_deg(alpha_deg);
c_l=4*alpha/sqrt(M_infinite^2-1);

a_infinite=sqrt(gama*R*T_infinite);
V_infinite=a_infinite*M_infinite;
q_infinite=(1/2)*rho_infinite*V_infinite^2;
L=q_infinite*S*c_l;
lift_to_drag_ratio=L/W;

/*The  answer may slightly vary due to  rounding off values*/
end Ex5_13;
