class Ex5_16
/*velocity- 60 mi/h=88 ft/s;*/
parameter Real pi = Modelica.Constants.pi;

parameter Real e =0.95;/*span effictiveness factor*/
parameter Real W(unit="N")=7.5*10^5;/*weight of aircraft*/
Real L(unit="N");/*lift of aircraft*/

parameter Real S(unit="m^2")=206;/*wing planform area*/
Real AR=10;/*aspect ratio of the aircraft*/

parameter Real V_infinite(unit="m/s")=100;/*flight velocity of aircraft*/
parameter Real rho_infinite(unit="kg/m^3")=0.909;/* atmospheric density at 3km*/
Real q_infinite(unit="N/m^2");/*dynamics pressure*/

Real C_L;/*lift coefficient*/

Real C_Di;/*induced drag coefficient*/
parameter Real c_d=0.006;/*profile drag coefficient*/
Real C_D;/*total drag coefficient*/
Real D(unit="N");/*total drag*/

equation
q_infinite=(1/2)*rho_infinite*V_infinite^2;
L=W;
C_L=L/(q_infinite*S);

C_Di=C_L^2/(pi*e*AR);
C_D=c_d+C_Di;
D=q_infinite*S*C_D;

/*The  answer may slightly vary due to  rounding off values*/
end Ex5_16;
