class Ex5_20
/*weight- 1 kgf=9.8 N;*/
/*Velocity- 60 mi/h=26.82 m/s;*/

parameter Real rho_infinite(unit="kg/m^3")=1.23;/* atmospheric density*/
parameter Real S(unit="m^2")=18.21;/*wing planform area*/
parameter Real C_L_max=1.15;/*maximum lift coefficient*/

/*for full tank*/
parameter Real W_f(unit="kgf")=10258;/*weight of aircraft with full tank in kgf*/
Real W_f_SI(unit="N");/*weight of aircraft with full tank  in SI units*/

Real V_stall_SI_f(unit="m/s");/*flight velocity of aircraft with full tank in SI units*/
Real V_stall_f(unit="mi/h");/*flight velocity of aircraft with full tank in miles per hour*/

/*for empty tank*/
parameter Real W_e(unit="kgf")=6071;/*weight of aircraft with empty tank in kgf*/
Real W_e_SI(unit="N");/*weight of aircraft with full empty  in SI units*/

Real V_stall_SI_e(unit="m/s");/*flight velocity of aircraft with empty tank in SI units*/
Real V_stall_e(unit="mi/h");/*flight velocity of aircraft with empty tank in miles per hour*/

equation
/*Number-a*/
/*for full tank*/
W_f_SI=W_f*9.8;
V_stall_SI_f=sqrt((2*W_f_SI)/(rho_infinite*S*C_L_max));
V_stall_f=V_stall_SI_f*(60/26.82);

/*Number-b*/
/*for empty tank*/
W_e_SI=W_e*9.8;
V_stall_SI_e=sqrt((2*W_e_SI)/(rho_infinite*S*C_L_max));
V_stall_e=V_stall_SI_e*(60/26.82);
end Ex5_20;
